class Proj_WaterTower extends Proj_Tower;

#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=WaterTowerBase anivfile=Models\WaterTowerBase_a.3d datafile=Models\WaterTowerBase_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=WaterTowerBase x=0 y=0 z=0
#exec mesh sequence mesh=WaterTowerBase seq=All startframe=0 numframes=1
#exec meshmap new meshmap=WaterTowerBase mesh=WaterTowerBase
#exec meshmap scale meshmap=WaterTowerBase x=0.18750 y=0.18750 z=0.37500
// !original size! #exec meshmap scale meshmap=WaterTowerBase x=0.37500 y=0.37500 z=0.75000

var float Disruption, SpawnTime;
var() float DisruptionThreshold;
var pawn Disruptor;
var Weapon_WaterTower Master;
var Actor DesiredTarget;
var bool bAlreadyHit, bTempDamage;
var vector RealLocation;
var TranslocGlow Glow;
var class<TranslocGlow> GlowColor[4];
var Decal Shadow;
var Tower T;
var class<Tower> TowerType;
var int TowerNum;

//Vars:
var Pawn 	TowerOwner;
var int 	Counter;
var bool	bMisplaced;
var bool	bIsInWater;

Replication
{
	UnReliable if ( Role == ROLE_Authority )
		RealLocation, Glow, T;
}

function Init()
{
	Master = None;
	if ( TowerType == Class'Tower_LaserCannon' )
		T = Spawn(TowerType, , , Self.Location - Vect(0,0,10));
	else if ( TowerType == Class'Tower_Warlord' )
		T = Spawn(TowerType, , , Self.Location + Vect(0,0,45));
	else if ( TowerType == Class'Tower_RingOfFire' )
		T = Spawn(TowerType, , , Self.Location + Vect(0,0,30));
	else
		T = Spawn(TowerType, , , Self.Location + Vect(0,0,40));
	T.SetPoint = Self.Location + Vect(0,0,40);
	T.TowerOwner = TowerOwner;
	T.TakeDamage( 1, TowerOwner, Location, 1*Vect(1,1,1), 'nulled');
	T.TowerNum = TowerNum;
	T.Base = Self;
	SetCollision(False,False,False);
}

simulated function Destroyed()
{
	if ( Shadow != None )
		Shadow.Destroy();
	if ( Glow != None )
		Glow.Destroy();
	Super.Destroyed();
}

function bool Disrupted()
{
	bIsInWater = False;
	return ( Disruption > DisruptionThreshold );
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
		return; 

	SetPhysics(PHYS_Falling);
	GotoState('PickUp');
}

simulated singular function ZoneChange( ZoneInfo NewZone )
{
local float splashsize;
local actor splash;
local rotator newRot;
local vector Loc;

	if ( NewZone.IsA('NoPlayerZone') )
		{
		Master.bTTargetOut = false;
		bMisplaced = True;
		Self.Destroy();
		TowerOwner.ReceiveLocalizedMessage( class'WrongTowerPlacementMessage',, );
		}

	if( NewZone.bWaterZone )
	{
	bIsInWater = True;
	if( TowerType == Class'Tower_LaserCannon' ) // Must be changed into water tower(s)!!
		{
		// Else play a splash.
		splashSize = FClamp(0.0001 * Mass * (250 - 0.5 * FMax(-600,Velocity.Z)), 1.0, 3.0 );
		if( NewZone.EntrySound != None )
			PlaySound(NewZone.EntrySound, SLOT_Interact, splashSize);
		if( NewZone.EntryActor != None )
			{
			splash = Spawn(NewZone.EntryActor); 
			if ( splash != None )
				{
				splash.DrawScale = splashSize;
				splash.RemoteRole = ROLE_None;
				}
			}
		Velocity.X = 0;
		Velocity.Y = 0;
		Velocity.Z = 0;
		SetPhysics(PHYS_Flying);
		Loc = Location + Vect(0,0,10);
		SetLocation(Loc);
		newRot = Rotation;
		newRot.Pitch = 0;
		newRot.Roll = 0;
		SetRotation(newRot);
		}
	else
		{
		Master.bTTargetOut = false;
		bMisplaced = True;
		bIsInWater = False;
		Self.Destroy();
		TowerOwner.ReceiveLocalizedMessage( class'WrongTowerPlacementMessage',, );
		}
	}
}

function Throw(Pawn Thrower, float force, vector StartPosition)
{
	local vector dir;

	dir = vector(Thrower.ViewRotation);
	Velocity = (0.66 * force) * dir + vect(0,0,50);
	// !original velocity! Velocity = (0.33 * force) * dir + vect(0,0,50);
	bBounce = true;
	DropFrom(StartPosition);
}

////////////////////////////////////////////////////////
auto state Pickup
{
	simulated function Timer()
	{
		
	}

	simulated event Landed( vector HitNormal )
	{
	local rotator newRot;
	
	if ( bIsInWater )
		{
		SetTimer(2.5, false);
		newRot = Rotation;
		newRot.Pitch = 0;
		newRot.Roll = 0;
		SetRotation(newRot);
		}
	else
		{
		Master.bTTargetOut = false;
		bMisplaced = True;
		Self.Destroy();
		TowerOwner.ReceiveLocalizedMessage( class'WrongTowerPlacementMessage',, );
		}
	}		

	function AnimEnd()
	{
		local int glownum;

		if ( (Physics != PHYS_None) || (Glow != None) || (Instigator.PlayerReplicationInfo == None) || Disrupted() )
			return;

	/*	glownum = Instigator.PlayerReplicationInfo.Team;
		if ( glownum > 3 )
			glownum = 0;
			
		Glow = spawn(GlowColor[glownum], self);
	*/
	}

	event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
	
	}

	singular function Touch( Actor Other )
	{
		
	}

	simulated function HitWall (vector HitNormal, actor Wall)
	{
		if ( bAlreadyHit )
		{
			bBounce = false;
			return;
		}
		bAlreadyHit = ( HitNormal.Z > 0.7 );
		PlaySound(ImpactSound, SLOT_Misc);	  // hit wall sound
		Velocity = 0.3*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		speed = VSize(Velocity);
	}


simulated function Tick(float DeltaTime)
	{
		if (Shadow == None)
			{
			Shadow = spawn(class'TowerSightRadius',self,,,rot(16384,0,0));
			}
		else
			{
			if ( TowerType == Class'Tower_Krall' )
				{
				if ( PBPRI(TowerOwner.PlayerReplicationInfo).KrallLevel == 1 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level1';
					Shadow.DrawScale = 2.60;
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).KrallLevel == 2 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level2';
					Shadow.DrawScale = 2.60;
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).KrallLevel == 3 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level3';
					Shadow.DrawScale = 2.60;
					}
				else
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Base';
					Shadow.DrawScale = 1.75;
					}
				}
			else if ( TowerType == Class'Tower_Slith' )
				{
				if ( PBPRI(TowerOwner.PlayerReplicationInfo).SlithLevel == 1 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level1';
					Shadow.DrawScale = 2.60;
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).SlithLevel == 2 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level2';
					Shadow.DrawScale = 2.60;
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).SlithLevel == 3 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level3';
					Shadow.DrawScale = 2.60;
					}
				else
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Base';
					Shadow.DrawScale = 1.75;
					}
				}
			else if ( TowerType == Class'Tower_LaserCannon' )
				{
				if ( PBPRI(TowerOwner.PlayerReplicationInfo).LaserCannonLevel == 1 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level1';
					Shadow.DrawScale = 2.00;
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).LaserCannonLevel == 2 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level2';
					Shadow.DrawScale = 2.25;
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).LaserCannonLevel == 3 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level3';
					Shadow.DrawScale = 2.50;
					}
				else
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Base';
					Shadow.DrawScale = 1.75;
					}
				}
			else if ( TowerType == Class'Tower_Warlord' )
				{
				if ( PBPRI(TowerOwner.PlayerReplicationInfo).WarlordLevel == 1 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level1';
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).WarlordLevel == 2 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level2';
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).WarlordLevel == 3 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level3';
					}
				else
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Base';
					}
				Shadow.DrawScale = 1.75;
				}
			else if ( TowerType == Class'Tower_Nali' )
				{
				if ( PBPRI(TowerOwner.PlayerReplicationInfo).NaliLevel == 1 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level1';
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).NaliLevel == 2 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level2';
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).NaliLevel == 3 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level3';
					}
				else
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Base';
					}
				Shadow.DrawScale = 1.75;
				}
			else if ( TowerType == Class'Tower_RingOfFire' )
				{
				if ( PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel == 1 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level1';
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel == 2 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level2';
					}
				else if ( PBPRI(TowerOwner.PlayerReplicationInfo).RingOfFireLevel == 3 )
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Level3';
					}
				else
					{
					MultiSkins[1] = Texture'PopBalloonsTextures.Towers.Base';
					}
				Shadow.DrawScale = 1.75;
				}
			}
		
		if ( Role != ROLE_Authority )
		{
			//Disable('Tick');
			return;
		}
		
		if ( (DesiredTarget == None) || (Master == None) )
			{
			//Disable('Tick');
			//if ( Master.Owner.IsA('PlayerPawn') && (Pawn(Master.Owner).Weapon == Master) )
			//	PlayerPawn(Master.Owner).SwitchToBestWeapon();
			return;
			}

		if ( (Abs(Location.X - DesiredTarget.Location.X) < Master.Owner.CollisionRadius)
			&& (Abs(Location.Y - DesiredTarget.Location.Y) < Master.Owner.CollisionRadius) )
			{
			if ( !FastTrace(DesiredTarget.Location, Location) )
				return;	

			Pawn(Master.Owner).StopWaiting();
			Master.Translocate();
			if ( Master.Owner.IsA('PlayerPawn') && (Pawn(Master.Owner).Weapon == Master) )
				PlayerPawn(Master.Owner).SwitchToBestWeapon();
			//Disable('Tick');
			}
	}
}

defaultproperties
{
     DisruptionThreshold=65.000000
	 TowerType=Class'Tower_Krall'
     GlowColor(0)=Class'Botpack.TranslocGlow'
     GlowColor(1)=Class'Botpack.TranslocBLue'
     GlowColor(2)=Class'Botpack.TranslocGreen'
     GlowColor(3)=Class'Botpack.TranslocGold'
     ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
     bNetTemporary=False
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.000000
     AmbientSound=Sound'Botpack.Weapon_Tower.targethum'
	 Mesh=Mesh'WaterTowerBase'
     SoundRadius=20
     SoundVolume=100
     CollisionRadius=64.00000
	 CollisionHeight=16.00000
	 bBlockActors=True
	 bBlockPlayers=True
	 MultiSkins(0)=Texture'PopBalloonsTextures.Colors.Tube'
	 MultiSkins(1)=Texture'PopBalloonsTextures.Colors.cBlack'
     bProjTarget=False
     bBounce=True
     Mass=50.000000
	 DrawScale=0.5
}
